#include <Wt/WApplication>
#include <Wt/WBreak>
#include <Wt/WContainerWidget>
#include <Wt/WLineEdit>
#include <Wt/WPushButton>
#include <Wt/WText>
#include <Wt/WLabel>
#include <Wt/WMessageBox>
#include <Wt/WMessageBox>
#include "LoginWidget.h"

using namespace Wt;

class HelloApplication : public WApplication
{
private:
    LoginWidget* login;
    bool validPass(const std::string& user, const std::string& pass)
    {
        WMessageBox::show(user, pass, Ok);
        return true;
    }

    void notifyEvent(NotifyEvent event)
    {
        WMessageBox::show("notify", boost::lexical_cast<std::string>(event), Ok);
        if (event == LoginSuccessful)
        {
            login->hide();
        }
    }


public:
    HelloApplication(const WEnvironment& env)
        : WApplication(env)
    {
        WApplication::instance()->useStyleSheet("wt.css");
        login = new LoginWidget(root());
        login->setupValidLoginMethod((LoginWidget::ValidLoginMethod)(&HelloApplication::validPass), this);
        login->setupNotifyEventMethod((LoginWidget::NotifyMethod)(&HelloApplication::notifyEvent), this);

    }

};

WApplication *createApplication(const WEnvironment& env)
{
    return new HelloApplication(env);
}

int main(int argc, char **argv)
{
    return WRun(argc, argv, &createApplication);
}
