/* this is a -*-C++-*- file
 * Copyright (C) 2005 Wim Dumon
 *
 * See the LICENSE file for terms of use.
 */

#ifndef LOGINWIDGET_H_
#define LOGINWIDGET_H_

#include <Wt/WContainerWidget>
#include <Wt/WSignal>
#include <Wt/WJavaScript>
#include <Wt/WPushButton>
#include <Wt/MD5PasswordEdit.h>

namespace Wt
{
    class WLineEdit;
    class WText;
    class WComboBox;
}

using namespace Wt;

enum NotifyEvent
{
    LoginSuccessful,
    LoginFailed,
};


class LoginWidget : public WContainerWidget
{
public:
    //typedef bool (WObject::*ValidLoginMethod)(const std::string& user, const std::string& pass);
    typedef bool (WObject::*ValidLoginMethod)(const std::string& user, const std::string& pass);
    typedef void (WObject::*NotifyMethod)(NotifyEvent event);
    LoginWidget(WContainerWidget *parent = 0);

    void setupValidLoginMethod(ValidLoginMethod validLoginMethod, WObject* loginObj);
    void setupNotifyEventMethod(NotifyMethod notifyMethod, WObject* notifyObj);
private:
    void checkCredentials(std::string passwordInMD5);
    WText     *IntroText;
    WLineEdit *Username;
    MD5PasswordEdit *Password;
    WPushButton *LoginButton;
    ValidLoginMethod m_validMethod;
    WObject*   m_loginObj;
    NotifyMethod m_notifyMethod;
    WObject*   m_notifyObj;
};

#endif
