
#include <functional>
#include <Wt/WText>
#include <Wt/WLabel>
#include <Wt/WLineEdit>
#include <Wt/WBreak>
#include <Wt/WCssDecorationStyle>
#include <Wt/WPushButton>
#include <Wt/WTable>
#include <Wt/WTableCell>
#include <Wt/WComboBox>
#include <Wt/WMessageBox>
#include "LoginWidget.h"
#include <Wt/MD5PasswordEdit.h>

using namespace std;

LoginWidget::LoginWidget(WContainerWidget *parent)
    :WContainerWidget(parent), m_validMethod(NULL), m_loginObj(NULL),
    m_notifyMethod(NULL), m_notifyObj(NULL)
{
    setPadding(100, Left | Right);

    IntroText = new WText("<p>Enter your user name and password below.</p>", this);

    WTable *layout = new WTable(this);
    WLabel *usernameLabel = new WLabel("User name: ", layout->elementAt(0, 0));
    layout->elementAt(0, 0)->resize(WLength(14, WLength::FontEx), WLength::Auto);
    Username = new WLineEdit(layout->elementAt(0, 1));
    usernameLabel->setBuddy(Username);

    WLabel *passwordLabel = new WLabel("Password: ", layout->elementAt(1, 0));

    Password = new MD5PasswordEdit(layout->elementAt(1, 1));
    passwordLabel->setBuddy(Password);

    new WBreak(this);
    LoginButton = new WPushButton("Login", layout->elementAt(2, 0));

    Password->setIncomingSignal(LoginButton->clicked());
    Password->setOutgoingSignal((MD5PasswordEdit::WObjectMethod)(&LoginWidget::checkCredentials), this);
}


void LoginWidget::setupValidLoginMethod(ValidLoginMethod validLoginMethod, WObject* loginObj)
{
    m_validMethod = validLoginMethod;
    m_loginObj = loginObj;
}


void LoginWidget::setupNotifyEventMethod(NotifyMethod notifyMethod, WObject* notifyObj)
{
    m_notifyMethod = notifyMethod;
    m_notifyObj = notifyObj;
}

void LoginWidget::checkCredentials(std::string passwordInMD5)
{
    bool bValid = false;
    if (m_validMethod)
    {
        //bValid = boost::bind<ValidLoginMethod, WObject*, const std::string&, const std::string&>(m_validMethod, m_loginObj, Username->text().toUTF8(), passwordInMD5);
        //bValid = boost::bind(m_validMethod, m_loginObj, Username->text().toUTF8(), passwordInMD5);
        bValid = boost::bind<bool>(m_validMethod, m_loginObj, _1, _2)(Username->text().toUTF8(), passwordInMD5);
        if (!bValid)
        {
            IntroText->setText("<p>You entered the wrong password, or the username "
                      "combination is already in use. If you are a returning "
                      "user, please try again. If you are a new user, please "
                      "try a different name.</p>");
            IntroText->decorationStyle().setForegroundColor(Wt::red);
            Username->setText("");
            Password->setText("");
            if (m_notifyMethod)
            {
                boost::bind<void>(m_notifyMethod, m_notifyObj, _1)(LoginFailed);
            }
        }
        else
        {
            if (m_notifyMethod)
            {
                boost::bind<void>(m_notifyMethod, m_notifyObj, _1)(LoginSuccessful);
            }
        }
    }
}


