
(load "board.scm")
(load "ShortestPath.scm")
(load "alpha-beta.scm")
;(load "alex.scm")
(load "displayboard.scm")



(define CoordList '())
(define n_firstMove #t)
(define n_secondMove #t)
(define n_firstMoveCoord '(5 . 5))

(define n_secondMoveCoord '(7 . 5))

(define FirstMove 
	(lambda (board player)		
		(MoveBoard board player n_firstMoveCoord)			
		(DisplayBoard board)
		#f
	)
)

(define SecondMove 
	(lambda (board player)		
		(MoveBoard board player n_secondMoveCoord)			
		(DisplayBoard board)
		#f
	)
)

;(define MinMax
;	(lambda (board color)
;		(l_alpha-beta MaxDepth board color DefaultAlphaValue DefaultBetaValue #t)
;	)
;)
;(define n_currentDepth 0)


(define DisplayBoard 
	(lambda (board)
		(a_BoardDisplay board) 
	)
)

(define MoveBoard
	(lambda (board color coord)
		(if color
			(vector-set! (vector-ref board (car coord)) (cdr coord) 'R)
			(vector-set! (vector-ref board (car coord)) (cdr coord) 'B)
		)
	)
)


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; function to decide if there is a winner
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define Judge
	(lambda (board color)
		(= (car (ShortestPath board color)) 0)
	)
)

(define DisplayResult
	(lambda (board winner)
		(if winner
			(pp "Red is winning!")
			(pp "Blue is winning!")
		)
		;(DisplayBoard board)
		(let loop ((ls CoordList)(color #t))
			(if (not (null? ls))
				(begin
					(if color 
						(pp (list "Red" (car (car ls)) (cdr (car ls))) )
						(pp (list "Blue" (car (car ls)) (cdr (car ls))) )
					)
					(loop (cdr ls)(not color))
				)
			)
		)
	)
)


(define move
	(lambda (board player)
		(if n_firstMove
			(begin
				(set! n_firstMove #f)
				(set! CoordList (append CoordList (list n_firstMoveCoord)))
				(FirstMove board player)
			)
			;;else
			(if n_secondMove
				(begin
					(set! n_secondMove #f)
					(set! CoordList (append CoordList (list n_secondMoveCoord)))
					(SecondMove board player)
				)			
				
				;; else
				(begin
					;(pp (list "before minmax " board))
					;(DisplayBoard board)
					(let ((step (MinMax board player)))
						(set! CoordList (append CoordList (list step)))
						(MoveBoard board player step)
						(DisplayBoard board)
						(if (Judge board player)
							(begin
								(DisplayResult board player)
								#t
							)
							#f
						)
					)
				)
			)
		)
	)
)

					
