; Hex board game definitions & functions
; COMP 472/6721 - Introduction to AI
; Project 2
;

; a hex board is of size NxN
(define board-size 11)

; each hexagon on the board is either empty, marked red, or marked blue
; we represent these as Scheme symbols 'R, 'B, and 'E
(define blue 'B)
(define red 'R)
(define empty 'E)

; a board is a vector of size N of vectors of size N,
; each element in the NxN matrix is initialized to "empty"
; board[0] gives you the top row, and board[0][0] its leftmost column
(define board (do ((board (make-vector board-size))
		   (i 0 (+ i 1)))
		  ((= i board-size) board)
		(vector-set! board i (make-vector board-size empty))))

; play a game until one side wins
(define (play board)
    (let loop ((player #t))         ; red starts
	  (begin (pp (list "loop begins player=" player))
      ;(if (not (time (move board player)))
	  (if (not (move board player))

	  (loop (not player))))
	  )
)



;------------------------------------------------
; make a move - implement this in a file hex.scm!
;
; "board" is of size NxN as define above,
;         changed by this function to add a move
;
; "player" is boolean, #t for red and #f for blue
;
; <return> value of this function is a boolean,
;          #t for win (current player wins),
;          #f for no win (game continues)
;
;(define (move board player)
;  ...
;)
;------------------------------------------------

