(load "ShortestPath.scm")

(define MaxDepth 6)
(define DefaultAlphaValue -999)
(define DefaultBetaValue  999)

(define DoMove
	(lambda (board color coord)
		(if color
			(n_vectorset board (car coord)(cdr coord) 'R)
			(n_vectorset board (car coord)(cdr coord) 'B)
		)
	)
)


(define MinMax
	(lambda (board color)
		(l_alpha-beta MaxDepth board (not color) DefaultAlphaValue DefaultBetaValue #t)
	)
)

(define ChooseBranching
	(lambda (board color)
		(n_doChooseBranching board color (n_unionPath (cdr (ShortestPath board #t))(cdr (ShortestPath board #f))))
	)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This is the major function of Heuristic
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define Heuristic
	(lambda (board)
		(- (car (ShortestPath board #f)) (car (ShortestPath board #t)))
	)
)



(define l_alpha-beta
  (lambda (depth  board colour alpha beta top)
    (define break #f)
    (define h 0)
    (define val 0)
    (define bestmove 0)
    (define minmaxVal -999999)
    (define h_M (ChooseBranching board colour))
     
    (if (= depth 0)
        (begin
          (Heuristic board)
        )
        (begin
       (if (null? h_M)
            (Heuristic board)
        (begin
          (do ((h_moves h_M (cdr h_moves))) (break) 
                (begin
                  (set! val (- (l_alpha-beta (- depth 1) (DoMove board colour (car h_moves)) (not colour) (- beta ) ( - alpha )  #f))) 
                  (if (>= val beta)
                      (begin
                        (set! bestmove (car h_moves))
                        (set! minmaxVal val)
                        (set! break #t)
                      )
                      (begin
                        (if (> val alpha)
                            (begin
                              (set! bestmove (car h_moves))
                              (set! alpha val)
                              (set! minmaxVal val)
                            )
                          )
                        (if (null? (cdr h_moves))
                            (begin
                              (set! minmaxVal alpha)
                              (set! break #t)
                            )
                          )
                        )
                      )
                    )
                  )
                
              (if top
                  bestmove
                  minmaxVal
              )))
            )
          )
        )
    )
