;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;; Human vs. AI interface
;; author: qingzhe huang
;; date: Nov. 29, 2005
;; usage: load this file and run (humanplay board)
;;		  at prompt, key in coordinate with row of capital letter, column of lower case letter
;;		  e.g.  "Fg" will be translated as (5 . 6), no space is allowed in between
;;        My program would not check or tolerate any mistakes of coordinate
;;        
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(load "DisplayBoard.scm")
(load "moveboard.scm")

(define RowBase (char->integer #\A))
(define ColBase (char->integer #\a))




(define read-coord
	(lambda()
		(let ((pr (read-pair)))
			(cons (- (char->integer (car pr)) RowBase) (- (char->integer (cdr pr)) ColBase))
		)
	)
)


(define read-pair
	(lambda ()
		(read-char) ; ignore the first newline
		(cons (read-char) (read-char))	
	)
)

(define (humanplay board)
	(let loop ((player #t))         ; red starts	
		(begin 
			(pp (list "loop begins player=" player))
			(display "key in coordinate with row in capital letter and column in lower letter and no space in between")
			(display #\newline)
			(display ">")
			(let ((coord (read-coord)))
				(MoveBoard board player coord)
				(set! CoordList (append CoordList (list coord)))
			)
			(DisplayBoard board)
			(if (not (Judge board player))
				(if (not (humanmove board (not player)))
					(loop  player)
					(DisplayResult board (not player))
				)
				(DisplayResult board player)
			)
		)
	)
)
				
(define humanmove
	(lambda (board player)	
		(if n_firstMove
			(begin
				(set! n_firstMove #f)
				(if (not (eq? (n_vectorget board (car n_firstMoveCoord) (cdr n_firstMoveCoord)) 'E))
					(set! n_firstMoveCoord (cons (+ (car n_firstMoveCoord) 2) (cdr n_firstMoveCoord)))
				)
				(set! CoordList (append CoordList (list n_firstMoveCoord)))
				(FirstMove board player)
			)
			(begin
				(pp (list "play continues the player is" player))
				(let ((step (MinMax board player)))
					(set! CoordList (append CoordList (list step)))
					(MoveBoard board player step)
					(DisplayBoard board)
					(if (Judge board player)
						(begin
							(DisplayResult board player)
							#t
						)
						#f
					)
				)
			)
		)
	)
)

