(load "ShortestPath.scm")

(define MaxDepth 3)
(define DefaultAlphaValue -999)
(define DefaultBetaValue  999)

(define MaxAlphaValue 999)
(define MinBetaValue  -999)

(define DoMove
	(lambda (board color coord)
		(if color
			(n_vectorset board (car coord)(cdr coord) 'R)
			(n_vectorset board (car coord)(cdr coord) 'B)
		)
	)
)
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;first choose the overlapped in n_union
;;; then we try to find connected
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define ChooseBranching
	(lambda (board color)
		(let ((path (n_unionPath (cdr (ShortestPath board #t))(cdr (ShortestPath board #f)))))
			(let ((result (n_doChooseBranching board color path)))
				(if (null? result)
					path
					result
				)
			)
		)
	)
)

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;  This is the major function of Heuristic
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
(define Heuristic
	(lambda (board)
		(- (car (ShortestPath board #f)) (car (ShortestPath board #t)))
	)
)

;(define n_doGetMinMax
;	(lambda (color numlst)
;		(let ((result 0))
;			(if color
;				(set! result DefaultAlphaValue)
;				(set! result DefaultBetaValue)
;			)
;			(let loop ((ls numlst))
;				(if (null? ls)
;					(begin ;(pp (list "n_doGetMinMax=" result "color=" color))						
;						result
;					)
;					(begin
;						(if color 
;							(set! result (max (car ls) result))
;							(set! result (min (car ls) result))
;						)
;						(loop (cdr ls))
;					)
;				)
;			)
;		)
;	)
;)



;(define n_getMinMaxValue
;	(lambda (board color depth)
;		(lambda (coord)			
;			(let ((path (ChooseBranching board color)))
;				(begin ;(pp (list "n_getMinMaxValue color=" color "depth=" depth "coord=" coord  "path=" path))
;				(cond
;					((and color (null? path)) DefaultBetaValue); red is winning
;					((and (not color)(null? path)) DefaultAlphaValue) ; blue is winning
;					((= depth MaxDepth) (Heuristic board))
;					(else
;						(n_doGetMinMax color 
;							(map (n_getMinMaxValue (DoMove board color coord) (not color)(+ depth 1)) path)))						
;				))
;			)
;		)
;	)
;)

(define n_getMinMaxValue
	(lambda (board color alpha beta coord depth)				
		(let ((path (ChooseBranching board color)))
			;(begin ;(pp (list "n_getMinMaxValue color=" color "depth=" depth "coord=" coord  "path=" path))
			(cond
				((and color (null? path)) DefaultBetaValue); red is winning
				((and (not color)(null? path)) DefaultAlphaValue) ; blue is winning
				((= depth MaxDepth) (Heuristic board))
				(else
					(begin
						(let ((result 0))
							(if color
								(set! result DefaultAlphaValue)
								(set! result DefaultBetaValue)
							)
							(let loop ((ls path))
								(if (null? ls)
									result
									(let ((value (n_getMinMaxValue (DoMove board color coord) (not color)
												alpha beta (car ls) (+ depth 1)) ))
										(cond
											((and color (> value beta)) value)
											((and (not color)(< value alpha)) value)
											((and color (> value alpha)) 
												(begin
													;(set! alpha value)
													(set! result value)
													(loop (cdr ls))
												)
											)
											((and (not color) (< value beta))
												(begin
													;(set! beta value)
													(set! result value)
													(loop (cdr ls))
												)
											)
											(else (loop (cdr ls)))
										)
									)
								)
							)
						)
					)
				)
			)
		)
	)
)

			


(define MinMax
	(lambda (board color)
		(let ((minmaxValue 0)(result '())(path (ChooseBranching board color)))	
			(set! result (car path))					
			(let loop ((ls path))
				(if color 
					(set! minmaxValue DefaultAlphaValue)
					(set! minmaxValue DefaultBetaValue)
				)						
				(begin ;(pp (list "loop continue with path=" path))
				(if (null? ls)					
					result
					(let ((value (n_getMinMaxValue board color DefaultAlphaValue DefaultBetaValue (car ls) 0) ))
						;(pp (list "for coord=" (car ls) "color=" color "value=" value "minmaxValue=" minmaxValue))
						(if (or (and color (> value minmaxValue))
								(and (not color) (< value minmaxValue)))
							(set! result (car ls))
						)
						(loop (cdr ls))
					)
				))
			)
		)
	)
)
			
					
					

